<?php

///////////////////////////////////////
//	SWP26 Stundenplaner
//	useradmin.php
//	
//	Adminbereich fr den Benutzerverwalter
//	Formulare zum Anlegen, Bearbeiten und Lschen von Benutzern/Admins
//	sowie das Ausfhren der Befehle
///////////////////////////////////////

if ( $admin_ist_eingelogged && $_SESSION["admin_typ"] == 'benutzeradmin' ) // Admin ist eingelogged und Benutzerverwalter
{
	?>
<table width="100%">
<tr><th>Benutzeradministration</th></tr>
<tr><td>
	<?php
	// die ausgewhlte Aktion in eine lok. Variable holen
	$action = "showList";		// default
	$thisAdmin = $_SESSION["admin_login"];
	$thisURL = "index.php?modul=admin&action=benutzer";
	
	// Regulrer Ausdruck fr eine Email-Addresse
	$preg_mail = "/[_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+\.)+([a-zA-Z]{2,3})/";
	$preg_name = "/[a-zA-Z0-9]{4,255}/";
	
	if ( $_POST["do"] )
		$action = $_POST["do"];
	else if ( $_GET["do"] )
		$action = $_GET["do"];
	
	// Verschiedene Aktionen hier:
	if ( $action == "addAdmin" )		// neuen Admin erstellen
	{
		// Fehlerabfrage: wurden alle Werte ordentlich gesetzt?
		$error_text = "";
		$has_error = false;
		
		// Name berprfen
		if ( $_POST["name"] )
		{
			// berprfung des Namens
			if( !preg_match( "$preg_name", $_POST["name"]) )
			{
				$has_error = true;
				$error_text .= "<li>Der Name ist zu kurz ( min. 4 ) oder zu lang ( max. 255 Zeichen ) oder enth&auml;lt Sonderzeichen bzw. Umlaute\n";
			}
		}
		else
		{
			$has_error = true;
			$error_text .= "<li>Name wurde vergessen einzutragen.\n";
		}
		// Passwort berprfen
		if ( $_POST["pw"] && $_POST["pw2"] )
		{
			// prfen der pw Lnge
			if ( strlen($_POST["pw"]) < 5 )
			{
				$has_error = true;
				$error_text .= "<li>Passwort ist zu kurz.\n";
			}
			else if ( $_POST["pw2"] != $_POST["pw"] )
			{
				$has_error = true;
				$error_text .= "<li>Passwortwiederholung ist falsch.\n";
			}
		}
		else
		{
			$has_error = true;
			$error_text .= "<li>Passwort wurde vergessen einzutragen.\n";
		}
		
		// Email berprfen
		if ( $_POST["email"] )
		{
			// auf den regulren ausdruck prfen
			if ( !preg_match("$preg_mail", $_POST["email"]) || substr_count( $_POST["email"], "@" ) != 1 )
			{
				$has_error = true;
				$error_text .= "<li>Emailaddresse ist ung&uuml;ltig.\n";
			}
		}
		else
		{
			$has_error = true;
			$error_text .= "<li>Email wurde vergessen einzutragen.\n";
		}
		
		// Die restlichen Daten knnen nicht fehlerhaft sein...
		if ( $_POST["rechte"] != 'datenadmin' && $_POST["rechte"] != 'benutzeradmin' && $_POST["rechte"] != 'deaktiviert' )
		{
			$has_error = true;
			$error_text .= "<li>Status fehlerhaft. Dieser Fehler sollte nie auftreten.\n";
		}
		
		// Sind Fehler aufgetreten -> 	ja: gib diese in einer Liste aus
		//				nein: schreibe Daten in DB
		if ( $has_error )
		{
			?><ul><?php
			echo $error_text;
			?></ul><?php
		}
		else
		{
			// Prfen ob der benutzer schon in der DB existiert
			$r = mysql_query( "SELECT id FROM verwalter WHERE name = '".$_POST["name"]."'" );
			if ( $data = mysql_fetch_assoc( $r ) )
			{
				// Ausgabe, das Benutzer bereits existiert
				?>
		<div>
			Benutzer existiert bereits in der Datenbank. Bitte anderen Namen verwenden.
		</div>
				<?php
			}
			else
			{			
				// Keine fehlerhaften Eingaben, Daten in die Datenbank eintragen
				// und Besttigung darber ausgeben
				
				// Standarddaten in DB einfgen
				$r = mysql_query( "INSERT INTO verwalter SET 	name = '".$_POST["name"]."',
										passwort = '".md5($_POST["pw"])."',
										email = '".$_POST["email"]."',
										status = '".$_POST["rechte"]."'" );
				$bid = mysql_insert_id();
						
				if ( $_POST["rechte"] == 'datenadmin' )
				{
					if ( is_array($_POST["fak"]) )
						foreach( $_POST["fak"] as $key => $data )
						{
							// abfragen hier und dann rechte eintragen
							if ( $data == "true" )
								mysql_query( "INSERT INTO verwalter_rechte SET 	benutzer_id = ".$bid.", fakultaet = ".$key );
						}
				}
				?>
		<div>
			Benutzer <b><?php echo $_POST["name"]; ?></b> wurde erfolgreich angelegt.
		</div>
				<?php
			}
		}
	}
	else if ( $action == "editAdmin" )	// bestehenden Admin bearbeiten
	{
		// Fehlerabfrage: wurden alle Werte ordentlich gesetzt?
		$error_text = "";
		$has_error = false;
		
		// ID prfen, sonst Problem
		if ( !($_POST["editID"] && is_numeric($_POST["editID"]) ) )
		{
			$has_error = true;
			$error_text .= "<li>Der Benutzer wurde nicht richtig ausgew&auml;hlt.\n";
		}			
		// Name berprfen
		if ( $_POST["name"] )
		{
			// berprfung des Namens
			if( !preg_match( "$preg_name", $_POST["name"]) )
			{
				$has_error = true;
				$error_text .= "<li>Der Name ist zu kurz ( min. 4 ) oder zu lang ( max. 255 Zeichen ) oder enth&auml;lt Sonderzeichen bzw. Umlaute\n";
			}
		}
		else
		{
			$has_error = true;
			$error_text .= "<li>Name wurde vergessen einzutragen.\n";
		}
		// Passwort berprfen
		if ( $_POST["pw"] || $_POST["pw2"] )
		{
			// prfen der pw Lnge
			if ( strlen($_POST["pw"]) < 5 )
			{
				$has_error = true;
				$error_text .= "<li>Passwort ist zu kurz.\n";
			}
			else if ( $_POST["pw2"] != $_POST["pw"] )
			{
				$has_error = true;
				$error_text .= "<li>Passwortwiederholung ist falsch.\n";
			}
		}	// wurde kein Passwort gesetzt, bleibt das alte...
					
		// Email berprfen
		if ( $_POST["email"] )
		{
			// auf den regulren ausdruck prfen
			if ( !preg_match("$preg_mail", $_POST["email"]) || substr_count( $_POST["email"], "@" ) != 1 )
			{
				$has_error = true;
				$error_text .= "<li>Emailaddresse ist ung&uuml;ltig.\n";
			}
		}
		else
		{
			$has_error = true;
			$error_text .= "<li>Email wurde vergessen einzutragen.\n";
		}
		
		// Die restlichen Daten knnen nicht fehlerhaft sein...
		if ( $_POST["rechte"] != 'datenadmin' && $_POST["rechte"] != 'benutzeradmin' && $_POST["rechte"] != 'deaktiviert' )
		{
			$has_error = true;
			$error_text .= "<li>Status fehlerhaft. Dieser Fehler sollte nie auftreten.\n";
		}
		// auslesen der alten rechte und der anzahl der alten admin
		$cnt = array();
		$r_cnt = mysql_query("SELECT * FROM verwalter WHERE status = 'benutzeradmin'");
		while ( $cnt[] = mysql_fetch_array( $r_cnt ) ) {};
		
		$r_old = mysql_query("SELECT * FROM verwalter WHERE id = ".intval($_POST["editID"]) );
		$old = mysql_fetch_assoc( $r_old );
		if( $_POST["rechte"] == 'datenadmin' && $old["status"] == 'benutzeradmin' && count( $cnt ) - 1 < 2  )
		{
			$has_error = true;
			$error_text .= "<li>Statuswechsel nicht gestattet. Es wrden keine Benutzeradmins mehr vorhanden sein!\n";
		}
		
		// Sind Fehler aufgetreten -> 	ja: gib diese in einer Liste aus
		//				nein: schreibe Daten in DB
		if ( $has_error )
		{
			?><ul><?php
			echo $error_text;
			?></ul><?php
		}
		else
		{
			// Keine Fehler aufgetreten, also werden die daten aktualisiert.
			if ( $_POST["pw"] )
				mysql_query( "UPDATE verwalter SET 	name = '".$_POST["name"]."', 
									email = '".$_POST["email"]."',
									passwort = '".$_POST["pw"]."',
									status = '".$_POST["rechte"]."' WHERE id = ".intval($_POST["editID"]) );
			else
				mysql_query( "UPDATE verwalter SET 	name = '".$_POST["name"]."', 
									email = '".$_POST["email"]."',
									status = '".$_POST["rechte"]."' WHERE id = ".intval($_POST["editID"]) );
			
			// Nun noch die Fakulttsrechte aktualisieren
			if ( $_POST["rechte"] != 'datenadmin' )
				// alle ausser datenadmin brauchen keine weiteren Rechte
				mysql_query( "DELETE FROM verwalter_rechte WHERE benutzer_id = ".intval($_POST["editID"]) );
			else
			{
				// alle Fakultten und die bisher vergebenen Rechte auslesen
				$r1 = mysql_query("SELECT id, name FROM fakultaet WHERE 1");
				$r2 = mysql_query("SELECT id, fakultaet FROM verwalter_rechte WHERE benutzer_id = ".intval($_POST["editID"]) );
				
				// erstelle einen Array mit den bisherigen rechten
				$rechte = array();
				while( $rechte[] = mysql_fetch_assoc( $r2 ) )
				{}
				$checkbox = array();
				if ( is_array($_POST["fak"]) )
					foreach( $_POST["fak"] as $key => $data )
					{
						if ( $data == "true" )
							$checkbox[] = $key;
					}
				
				// alle Fak nacheinander durchgehn, und eintrge lschen oder hinzufgen, oder nix tun...
				while ( $data = mysql_fetch_assoc( $r1 ) )
				{
					// akt. Fak mit Eintrgen im Array rechte vergleichen
					$found = -1;
					for( $i = 0; $i < count($rechte); $i++ )
					{
						if ( $rechte[$i]["fakultaet"] == $data["id"] )
						{
							$found = $i;
							break;
						}
					}
					// Wenn Eintrag vorhanden, prfen, ob dieser bentigt ist.
					if ( $found > -1 && !in_array($data["id"],$checkbox) )	// Eintrag existiert, aber ist nicht ntig
					{
						mysql_query("DELETE FROM verwalter_rechte WHERE id = ".$rechte[$found]["id"] );
					}
					else if ( $found == -1 && in_array($data["id"],$checkbox) )	// Eintrag existiert nicht, aber wird bentigt
					{
						mysql_query("INSERT INTO verwalter_rechte SET benutzer_id = ".intval($_POST["editID"]).", fakultaet = ".$data["id"] );
					}
					
					// Ansonsten muss nichts verndert werden...					
				}
			}
			?>
	<div>
		Benutzer <b><?php echo $_POST["name"]; ?></b> wurde aktualisiert.
	</div>
			<?php	
		}
	}
	else if ( $action == "delAdmin" )	// bestehenden Admin lschen
	{
		// wurde auch eine ID bergeben und schon lschen besttigt
		if ( $_POST["delID"] && strtoupper($_POST["confirm"]) == "OK" )
		{
			// Lschen des Benutzers und seiner Rechte, wenn vorhanden.
			$r = mysql_query("SELECT name, status FROM verwalter WHERE id = ".intval($_POST["delID"]) );
			$delAdmin = mysql_fetch_assoc( $r );
			
			mysql_query("DELETE FROM verwalter WHERE id = ".intval($_POST["delID"]) );	// User lschen
			if ( $delAdmin["status"] == "datenadmin" )					// Userrechte lschen
				mysql_query("DELETE FROM verwalter_rechte WHERE benutzer_id = ".intval($_POST["delID"]) );
			
			// Lschbesttigung
			?><div>
				Der Benutzer <b><?php echo $delAdmin["name"]; ?></b> wurde aus der Datenbank gelscht.
			</div><?php
			
		}
		else if ( $_GET["delID"] && intval($thisAdmin["id"]) != intval($_GET["delID"]) )	// nur ID bergeben, also Sicherheitsabfrage
		{
			// Namen nochmal abrufen
			$r = mysql_query("SELECT name FROM verwalter WHERE id = ".$_GET["delID"] );
			$data = mysql_fetch_assoc( $r );
			
			// Besttigungsformular erstellen ( Sicherheitsabfrage )
			?>
			
			<form action="<?php
			echo $thisURL."&do=delAdmin";
			?>" method="post" name="delConfirm">
  				<div align="center">
    					ACHTUNG: Wollen Sie wirklich <strong><?php
    					echo $data["name"];
    					?></strong> l&ouml;schen?<br>
    					Der Benutzer verliert alle Rechte und kann sich nicht mehr einloggen.<br>
    					<input name="confirm" type="submit" id="confirm" value="OK">
    					<input name="cancel" type="submit" id="cancel" value="Abbrechen">
    					<input name="delID" type="hidden" id="delID" value="<?php echo $_GET["delID"]; ?>">
				</div>
			</form>
			<?php
		}
		else if ( intval($thisAdmin["id"]) == intval($_GET["delID"]) )
		{
			?>
			<div>
				Man kannst sich nicht selber l&ouml;schen. Dies ist ein Schutz.
			</div>
			<?php
		}
		else	// wurde zb. Abbrechen geklickt, zurck zur bersicht
			$action = "showList";
	}
	
	// Aufbau des Menus hier:
	if ( $action == "showList" )		// Liste aller Admins und dahinter die Optionen
	{
		// alle Datenadmins aus Datenbank lesen und dann in einer Liste prsentieren
		$r1 = mysql_query("SELECT * FROM verwalter WHERE status = 'datenadmin'");
		$r2 = mysql_query("SELECT * FROM verwalter WHERE status = 'benutzeradmin'");
		$r3 = mysql_query("SELECT * FROM verwalter WHERE status = 'deaktiviert'");
		
		// Tabellenkopf ausgeben:
		?>
		<center><a href="<?php echo $thisURL."&do=addAdminForm"; ?>"><img src="./icons/neu.gif" border=0 title="neuen Benutzer"/>neuen Benutzer hinzuf&uuml;gen</a></center>
		</td></tr><tr><td>
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td align="center"><b>&Uuml;bersicht Datenverwalter</b></td></tr><tr><td>
  		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td width="25%"><i>Name</i></td><td width="35%"><i>Email</i></td><td width="40%"><i>Optionen</i></td></tr>
		<?php
		
		while( $data = mysql_fetch_assoc($r1) )
		{
			// in einer Tabelle ausgeben
			?><tr><td><?php
			echo $data[name];
			?></td><td><?php
			echo $data[email];
			?></td><td><?php
			echo "<a href='".$thisURL."&do=editAdminForm&editID=".$data[id]."'><img src=\"./icons/bearbeiten.gif\" border=0 title=\"Benutzer ".$data[name]." bearbeiten\"/>bearbeiten</a> ";
			echo "<a href='".$thisURL."&do=delAdmin&delID=".$data[id]."'><img src=\"./icons/loeschen.gif\" border=0 title=\"Benutzer ".$data[name]." loeschen\"/>lschen</a> ";
			?></td></tr><?php
		}
		// Tabellenende ausgeben:
		?>
		</table></td></tr>
		</table>
		<br>
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td align="center"><b>&Uuml;bersicht Benutzerverwalter</b></td></tr><tr><td>
  		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td width="25%"><i>Name</i></td><td width="35%"><i>Email</i></td><td width="40%"><i>Optionen</i></td></tr>
		<?php
		
		while( $data = mysql_fetch_assoc($r2) )
		{
			// in einer Tabelle ausgeben
			?><tr><td><?php
			echo $data[name];
			?></td><td><?php
			echo $data[email];
			?></td><td><?php
			echo "<a href='".$thisURL."&do=editAdminForm&editID=".$data[id]."'><img src=\"./icons/bearbeiten.gif\" border=0 title=\"Benutzer ".$data[name]." bearbeiten\"/>bearbeiten</a> ";
			echo "<a href='".$thisURL."&do=delAdmin&delID=".$data[id]."'><img src=\"./icons/loeschen.gif\" border=0 title=\"Benutzer ".$data[name]." loeschen\"/>lschen</a> ";
			?></td></tr><?php
		}
		// Tabellenende ausgeben:
		?>
		</table></td></tr>
		</table>
		<br>
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td align="center"><b>&Uuml;bersicht deaktivierter Benutzer</b></td></tr><tr><td>
		<table width="100%" cellpadding="0" cellspacing="0">
		<tr><td width="25%"><i>Name</i></td><td width="35%"><i>Email</i></td><td width="40%"><i>Optionen</i></td></tr>
		<?php
		
		while( $data = mysql_fetch_assoc($r3) )
		{
			// in einer Tabelle ausgeben
			?><tr><td><?php
			echo $data[name];
			?></td><td><?php
			echo $data[email];
			?></td><td><?php
			echo "<a href='".$thisURL."&do=editAdminForm&editID=".$data[id]."'><img src=\"./icons/bearbeiten.gif\" border=0 title=\"Benutzer ".$data[name]." bearbeiten\"/>bearbeiten</a> ";
			echo "<a href='".$thisURL."&do=delAdmin&delID=".$data[id]."'><img src=\"./icons/loeschen.gif\" border=0 title=\"Benutzer ".$data[name]." loeschen\"/>lschen</a> ";
			?></td></tr><?php
		}
		// Tabellenende ausgeben:
		?>
		</table></td></tr>
		</table>
		<?php
	}
	else if ( $action == "editAdminForm" )	// Formular zum bearbeiten eines Admins
	{
		if ( $_GET["editID"] && is_numeric($_GET["editID"]) )	// wurde keine ID bergeben, nur neuen Admin einfgen
		{
			
			$r = mysql_query("SELECT id, name, email, status FROM verwalter WHERE id = '".$_GET["editID"]."'" );
			$editUser = mysql_fetch_assoc( $r );
		?>
<form name="editAdmin" action="<?php echo $thisURL."&do=editAdmin"; ?>" method="post">
  <input type="hidden" name="editID" value="<?php echo $_GET["editID"]; ?>">
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
      <td width="20%">Benutzername:</td>
      <td width="40%"> <input name="name" type="text" id="name" size="20" value="<?php echo $editUser["name"]; ?>"> 
      </td>
      <td width="40%">&nbsp;</td>
    </tr>
    <tr> 
      <td>Passwort:</td>
      <td><input name="pw" type="password" id="pw" size="20"></td>
      <td>min. 5 Zeichen. F&uuml;r altes Passwort leer lassen.</td>
    </tr>
    <tr> 
      <td>Passwortwiederholung:</td>
      <td><input name="pw2" type="password" id="pw2" size="20"></td>
      <td>Wiederholung</td>
    </tr>
    <tr> 
      <td>Email Adresse</td>
      <td><input name="email" type="text" id="email" size="20" value="<?php echo $editUser["email"]; ?>"></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td>Zugriffsrechte</td>
      <td><select name="rechte" id="rechte">
          <option value="datenadmin" <?php if ( $editUser["status"] == 'datenadmin' ) echo "selected"; ?>>Datenverwalter</option>
          <option value="benutzeradmin" <?php if ( $editUser["status"] == 'benutzeradmin' ) echo "selected"; ?>>Benutzerverwalter</option>
          <option value="deaktiviert" <?php if ( $editUser["status"] == 'deaktiviert' ) echo "selected"; ?>>Deaktiviert</option>
        </select></td>
      <td>allgemeinen Zugriffsrechte</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>
        <?php
      		// Liste der verfgbaren Fakultten
      		$r1 = mysql_query("SELECT id, name FROM fakultaet WHERE 1");
      		$r2 = mysql_query("SELECT fakultaet FROM verwalter_rechte WHERE benutzer_id = '".$_GET["editID"]."'" );
      		$rechte = array();
      		
      		while( $rechte[] = mysql_fetch_assoc( $r2 ) )	// in schleife solange Rechte auslesen, bis alle im array
      		{}
     			
      		while( $data = mysql_fetch_assoc( $r1 ) )
      		{
      			// Ausgabe des Kontrollkstchens und des Namens der Fak 
      			echo '<input name="fak['.$data["id"].']" type="checkbox" id="fak['.$data["id"].']" value="true"';
      			// berprfen, ob diese Fakultt in den Zugriffsrechten ist
      			for ( $i = 0; $i < count( $rechte ); $i++ )
      				if ( $rechte[$i]["fakultaet"] == $data["id"] )
      				{
      					echo " checked ";
      					break;
      				}
      			echo '>'.$data["name"]."<br />";
      		}
      ?>
      </td>
      <td>Zugriffsrechte auf Fakult&auml;ten f&uuml;r Datenverwalter.</td>
    </tr>
  </table>
  <div align="center">
    <input name="submit" type="submit" id="submit2" value="Abschicken">
    <input name="reset" type="reset" id="reset2" value="Zur&uuml;cksetzen">
  </div>
</form>
		<?php
		}
		else
			$action = "addAdminForm";
	}
	else if ( $action == "addAdminForm" )	// Formular zum hinzufgen eines Admins
	{
		?>
<form action="<?php echo $thisURL."&do=addAdmin"; ?>" method="post" name="addAdmin">
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
      <td width="20%">Benutzername:</td>
      <td width="50%">
<input name="name" type="text" id="name" size="20">
      </td>
      <td width="30%">&nbsp;</td>
    </tr>
    <tr> 
      <td>Passwort:</td>
      <td><input name="pw" type="password" id="pw" size="20"></td>
      <td>min. 5 Zeichen</td>
    </tr>
    <tr> 
      <td>Passwortwiederholung:</td>
      <td><input name="pw2" type="password" id="pw2" size="20"></td>
      <td>Wiederholung gegen Schreib-/Tipfehler</td>
    </tr>
    <tr> 
      <td>Email Adresse</td>
      <td><input name="email" type="text" id="email" size="20"></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td>Zugriffsrechte</td>
      <td><select name="rechte" id="rechte">
          <option value="datenadmin" selected>Datenverwalter</option>
          <option value="benutzeradmin">Benutzerverwalter</option>
          <option value="deaktiviert">Deaktiviert</option>
        </select></td>
      <td>allgemeinen Zugriffsrechte des Benutzers</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td><?php
      		// Liste der verfgbaren Fakultten
      		$r = mysql_query("SELECT id, name FROM fakultaet WHERE 1");
      		
      		while( $data = mysql_fetch_assoc( $r ) )
      		{
      			// Ausgabe des Kontrollkstchens und des Namens der Fak 
      			echo '<input name="fak['.$data["id"].']" type="checkbox" id="fak['.$data["id"].']" value="true">';
      			echo $data["name"]."<br />";
      		}
      ?>
        </td>
      <td>Zugriffsrechte auf Fakult&auml;ten f&uuml;r Datenverwalter.</td>
    </tr>
  </table>
  <div align="center"> 
    <input name="submit" type="submit" id="submit" value="Abschicken">
    <input name="reset" type="reset" id="reset" value="Zur&uuml;cksetzen">
  </div>
</form>
		<?php
	}
	?>
</td></tr>
</table>
	<?php
}
else
{
	// Fehlerausgabe
	echo "<b>Fehler:</b> nicht angemeldet oder nicht die entsprechenden Rechte!";
}
?>